/*
 * Decompiled with CFR 0.152.
 */
package br.com.okeaproject.project.service;

import br.com.okeaproject.project.entity.MembroProjeto;
import br.com.okeaproject.project.entity.Projeto;
import br.com.okeaproject.project.entity.Usuario;
import br.com.okeaproject.project.repository.MembroProjetoRepository;
import br.com.okeaproject.project.repository.PapelRepository;
import br.com.okeaproject.project.repository.ProjetoRepository;
import br.com.okeaproject.project.repository.UsuarioRepository;
import br.com.okeaproject.project.service.GeradorCronogramaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MembroProjetoService {
    @Autowired
    private MembroProjetoRepository membroRepository;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private ProjetoRepository projetoRepository;
    @Autowired
    private PapelRepository papelRepository;
    @Autowired
    private GeradorCronogramaService geradorCronogramaService;

    @Transactional
    public MembroProjeto adicionarMembroAoProjeto(Long projetoId, Long usuarioId, List<Long> papeisIds) {
        Projeto projeto = (Projeto)this.projetoRepository.findById((Object)projetoId).orElseThrow(() -> new RuntimeException("Projeto n\u00e3o encontrado"));
        Usuario usuario = (Usuario)this.usuarioRepository.findById((Object)usuarioId).orElseThrow(() -> new RuntimeException("Usu\u00e1rio n\u00e3o encontrado"));
        List papeis = this.papelRepository.findAllById(papeisIds);
        MembroProjeto novoMembro = new MembroProjeto();
        novoMembro.setProjeto(projeto);
        novoMembro.setUsuario(usuario);
        novoMembro.setPapeisAtribuidos(papeis);
        novoMembro = (MembroProjeto)this.membroRepository.save((Object)novoMembro);
        this.geradorCronogramaService.gerarTarefasParaNovoMembro(novoMembro);
        return novoMembro;
    }
}

