/*
 * Decompiled with CFR 0.152.
 */
package br.com.okeaproject.project.service;

import br.com.okeaproject.project.entity.MembroProjeto;
import br.com.okeaproject.project.entity.Papel;
import br.com.okeaproject.project.entity.Projeto;
import br.com.okeaproject.project.entity.Tarefa;
import br.com.okeaproject.project.entity.TarefaPadrao;
import br.com.okeaproject.project.enums.StatusTarefa;
import br.com.okeaproject.project.repository.TarefaPadraoRepository;
import br.com.okeaproject.project.repository.TarefaRepository;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GeradorCronogramaService {
    @Autowired
    private TarefaPadraoRepository tarefaPadraoRepository;
    @Autowired
    private TarefaRepository tarefaRepository;

    @Transactional
    public void gerarTarefasParaNovoMembro(MembroProjeto membro) {
        List modelos;
        Projeto projeto = membro.getProjeto();
        List papeis = membro.getPapeisAtribuidos();
        HashMap<Long, Tarefa> mapaDePara = new HashMap<Long, Tarefa>();
        for (Papel papel : papeis) {
            modelos = this.tarefaPadraoRepository.findByPapelDonoId(papel.getId());
            for (TarefaPadrao modelo : modelos) {
                Tarefa novaTarefa = new Tarefa();
                novaTarefa.setNome(modelo.getNome());
                novaTarefa.setOrdem(modelo.getOrdem());
                novaTarefa.setDuracaoEstimadaHoras(modelo.getDuracaoHoras());
                novaTarefa.setStatus(StatusTarefa.PENDENTE);
                novaTarefa.setResponsavel(membro);
                novaTarefa = (Tarefa)this.tarefaRepository.save((Object)novaTarefa);
                mapaDePara.put(modelo.getId(), novaTarefa);
            }
        }
        for (Papel papel : papeis) {
            modelos = this.tarefaPadraoRepository.findByPapelDonoId(papel.getId());
            for (TarefaPadrao modelo : modelos) {
                Tarefa tarefaReal = (Tarefa)mapaDePara.get(modelo.getId());
                if (modelo.getPreRequisitos() != null && !modelo.getPreRequisitos().isEmpty()) {
                    LocalDate maiorDataFim = projeto.getDataInicio();
                    boolean temPredecessoraValida = false;
                    for (TarefaPadrao preReqTemplate : modelo.getPreRequisitos()) {
                        Tarefa tarefaPaiReal = (Tarefa)mapaDePara.get(preReqTemplate.getId());
                        if (tarefaPaiReal == null || tarefaPaiReal.getDataFimCalculada() == null) continue;
                        temPredecessoraValida = true;
                        if (!tarefaPaiReal.getDataFimCalculada().isAfter(maiorDataFim)) continue;
                        maiorDataFim = tarefaPaiReal.getDataFimCalculada();
                    }
                    if (temPredecessoraValida) {
                        this.calcularDatas(tarefaReal, maiorDataFim, modelo.getDiasDefasagem());
                    } else {
                        this.calcularDatas(tarefaReal, projeto.getDataInicio(), modelo.getDiasDefasagem());
                    }
                } else {
                    this.calcularDatas(tarefaReal, projeto.getDataInicio(), modelo.getDiasDefasagem());
                }
                this.tarefaRepository.save((Object)tarefaReal);
            }
        }
    }

    private void calcularDatas(Tarefa tarefa, LocalDate dataBase, Integer diasDefasagem) {
        int defasagem = diasDefasagem != null ? diasDefasagem : 0;
        LocalDate inicioCalculado = dataBase.plusDays(defasagem);
        long diasDuracao = (long)Math.ceil(tarefa.getDuracaoEstimadaHoras() / 8.0);
        if (diasDuracao < 1L) {
            diasDuracao = 1L;
        }
        LocalDate fimCalculado = inicioCalculado.plusDays(diasDuracao);
        tarefa.setDataInicioCalculada(inicioCalculado);
        tarefa.setDataFimCalculada(fimCalculado);
    }
}

