/*
 * Decompiled with CFR 0.152.
 */
package br.com.okeaproject.project.controller;

import br.com.okeaproject.project.entity.Empresa;
import br.com.okeaproject.project.entity.EtapaPadrao;
import br.com.okeaproject.project.entity.TarefaPadrao;
import br.com.okeaproject.project.entity.Usuario;
import br.com.okeaproject.project.repository.EmpresaRepository;
import br.com.okeaproject.project.repository.EtapaPadraoRepository;
import br.com.okeaproject.project.repository.TarefaPadraoRepository;
import br.com.okeaproject.project.repository.UsuarioRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cadastros"})
public class CadastroController {
    @Autowired
    private EmpresaRepository empresaRepository;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private TarefaPadraoRepository tarefaPadraoRepository;
    @Autowired
    private EtapaPadraoRepository etapaPadraoRepository;

    @PostMapping(value={"/empresas"})
    public Empresa criarEmpresa(@RequestBody Empresa empresa) {
        return (Empresa)this.empresaRepository.save((Object)empresa);
    }

    @PutMapping(value={"/empresas"})
    public Empresa atualizarEmpresa(@RequestBody Empresa empresa) {
        return (Empresa)this.empresaRepository.save((Object)empresa);
    }

    @GetMapping(value={"/empresas"})
    public List<Empresa> listarEmpresas() {
        return this.empresaRepository.findAll();
    }

    @PostMapping(value={"/usuarios"})
    public Usuario criarUsuario(@RequestBody Usuario usuario) {
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }

    @PutMapping(value={"/usuarios"})
    public Usuario atualizarUsuario(@RequestBody Usuario usuario) {
        return (Usuario)this.usuarioRepository.save((Object)usuario);
    }

    @GetMapping(value={"/usuarios"})
    public List<Usuario> listarUsuarios() {
        return this.usuarioRepository.findAll();
    }

    @GetMapping(value={"/tarefas-padrao"})
    public List<TarefaPadrao> listarTarefasPadrao() {
        return this.tarefaPadraoRepository.findAll();
    }

    @PostMapping(value={"/tarefas-padrao"})
    public TarefaPadrao criarTarefaPadrao(@RequestBody TarefaPadrao tarefa) {
        return (TarefaPadrao)this.tarefaPadraoRepository.save((Object)tarefa);
    }

    @PutMapping(value={"/tarefas-padrao"})
    public TarefaPadrao atualizarTarefaPadrao(@RequestBody TarefaPadrao tarefa) {
        return (TarefaPadrao)this.tarefaPadraoRepository.save((Object)tarefa);
    }

    @GetMapping(value={"/etapas-padrao"})
    public List<EtapaPadrao> listarEtapasPadrao() {
        return this.etapaPadraoRepository.findAll(Sort.by((String[])new String[]{"ordem"}));
    }

    @PostMapping(value={"/etapas-padrao"})
    public EtapaPadrao criarEtapaPadrao(@RequestBody EtapaPadrao etapa) {
        return (EtapaPadrao)this.etapaPadraoRepository.save((Object)etapa);
    }

    @PutMapping(value={"/etapas-padrao"})
    public EtapaPadrao atualizarEtapaPadrao(@RequestBody EtapaPadrao etapa) {
        return (EtapaPadrao)this.etapaPadraoRepository.save((Object)etapa);
    }
}

